/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.shadow.google.gson.Gson;
import net.skinsrestorer.shadow.spiget.ResourceInfo;
import net.skinsrestorer.shadow.spiget.ResourceVersion;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shadow.spiget.comparator.VersionComparator;
import net.skinsrestorer.shared.utils.log.SRLogLevel;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class UpdateChecker {
    public static final String RESOURCE_INFO = "https://api.spiget.org/v2/resources/%s?ut=%s";
    public static final String RESOURCE_VERSION = "https://api.spiget.org/v2/resources/%s/versions/latest?ut=%s";
    private static final String LOG_ROW = "\u00a7a----------------------------------------------";
    protected final SRLogger log;
    protected final String userAgent;
    private final int resourceId;
    protected String currentVersion;
    private ResourceInfo latestResourceInfo;

    public UpdateChecker(int resourceId, String currentVersion, SRLogger log, String userAgent) {
        this.resourceId = resourceId;
        this.currentVersion = currentVersion;
        this.log = log;
        this.userAgent = userAgent;
    }

    public void checkForUpdate(UpdateCallback callback) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(RESOURCE_INFO, this.resourceId, System.currentTimeMillis())).openConnection();
            connection.setRequestProperty("User-Agent", this.userAgent);
            this.latestResourceInfo = new Gson().fromJson((Reader)new InputStreamReader(connection.getInputStream()), ResourceInfo.class);
            connection = (HttpURLConnection)new URL(String.format(RESOURCE_VERSION, this.resourceId, System.currentTimeMillis())).openConnection();
            connection.setRequestProperty("User-Agent", this.userAgent);
            this.latestResourceInfo.latestVersion = new Gson().fromJson((Reader)new InputStreamReader(connection.getInputStream()), ResourceVersion.class);
            if (this.isVersionNewer(this.currentVersion, this.latestResourceInfo.latestVersion.name)) {
                callback.updateAvailable(this.latestResourceInfo.latestVersion.name, "https://spigotmc.org/" + this.latestResourceInfo.file.url, !this.latestResourceInfo.external);
            } else {
                callback.upToDate();
            }
        }
        catch (Exception e) {
            this.log.debug(SRLogLevel.WARNING, "Failed to get resource info from spiget.org", e);
        }
    }

    public List<String> getUpToDateMessages(String currentVersion, boolean proxyMode) {
        LinkedList<String> upToDateMessages = new LinkedList<String>();
        this.fillHeader(upToDateMessages, proxyMode);
        upToDateMessages.add("\u00a7b    Current version: \u00a7a" + currentVersion);
        upToDateMessages.add("\u00a7a    This is the latest version!");
        upToDateMessages.add(LOG_ROW);
        return upToDateMessages;
    }

    public List<String> getUpdateAvailableMessages(String newVersion, String downloadUrl, boolean hasDirectDownload, String currentVersion, boolean proxyMode) {
        return this.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, currentVersion, proxyMode, false, null);
    }

    public List<String> getUpdateAvailableMessages(String newVersion, String downloadUrl, boolean hasDirectDownload, String currentVersion, boolean proxyMode, boolean updateDownloader, String failReason) {
        LinkedList<String> updateAvailableMessages = new LinkedList<String>();
        this.fillHeader(updateAvailableMessages, proxyMode);
        updateAvailableMessages.add("\u00a7b    Current version: \u00a7c" + currentVersion);
        updateAvailableMessages.add("\u00a7b    New version: \u00a7c" + newVersion);
        if (updateDownloader && hasDirectDownload) {
            updateAvailableMessages.add("    A new version is available! Downloading it now...");
            if (failReason == null) {
                updateAvailableMessages.add("    Update downloaded successfully, it will be applied on the next restart.");
            } else {
                updateAvailableMessages.add("\u00a7cCould not download the update, reason: " + failReason);
            }
        } else {
            updateAvailableMessages.add("\u00a7e    A new version is available! Download it at:");
            updateAvailableMessages.add("\u00a7e    " + downloadUrl);
        }
        updateAvailableMessages.add(LOG_ROW);
        return updateAvailableMessages;
    }

    private void fillHeader(List<String> updateAvailableMessages, boolean proxyMode) {
        updateAvailableMessages.add(LOG_ROW);
        updateAvailableMessages.add("\u00a7a    +==================+");
        updateAvailableMessages.add("\u00a7a    |   SkinsRestorer  |");
        if (proxyMode) {
            updateAvailableMessages.add("\u00a7a    |------------------|");
            updateAvailableMessages.add("\u00a7a    |    \u00a7eProxy Mode\u00a7a    |");
        } else if (this.isBukkit()) {
            updateAvailableMessages.add("\u00a7a    |------------------|");
            updateAvailableMessages.add("\u00a7a    |  \u00a79\u00a7n\u00a7lStandalone Mode\u00a7r\u00a7a |");
        }
        updateAvailableMessages.add("\u00a7a    +==================+");
        updateAvailableMessages.add(LOG_ROW);
    }

    public boolean isVersionNewer(String oldVersion, String newVersion) {
        return VersionComparator.SEM_VER_SNAPSHOT.isNewer(oldVersion, newVersion);
    }

    private boolean isBukkit() {
        return ReflectionUtil.classExists("org.bukkit.Bukkit");
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public ResourceInfo getLatestResourceInfo() {
        return this.latestResourceInfo;
    }
}

